package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (float, int) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface FloatIntToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param fl argument 1
     * @param i argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(float fl, int i) throws E;

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(fl, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    bind(FloatIntToShortE<E> f, float fl) {
        return (i) -> f.call(fl, i);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param fl argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(fl, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> bind(float fl) {
        return FloatIntToShortE.bind(this, fl);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(fl, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    rbind(FloatIntToShortE<E> f, int i) {
        return (fl) -> f.call(fl, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(fl, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> rbind(int i) {
        return FloatIntToShortE.rbind(this, i);
    }

    /**
     * Binds {@code (fl, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(FloatIntToShortE<E> f, float fl, int i) {
        return () -> f.call(fl, i);
    }

    /**
     * Binds {@code (fl, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl, i)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(float fl, int i) {
        return FloatIntToShortE.bind(this, fl, i);
    }
}
