package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (float, U) -> short}.
 *
 * @param <U> the type of argument 2
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface FloatObjToShortE<U, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param fl argument 1
     * @param u argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(float fl, U u) throws E;

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(fl, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<U, E>
    bind(FloatObjToShortE<U, E> f, float fl) {
        return (u) -> f.call(fl, u);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param fl argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(fl, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<U, E> bind(float fl) {
        return FloatObjToShortE.bind(this, fl);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(fl, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    rbind(FloatObjToShortE<U, E> f, U u) {
        return (fl) -> f.call(fl, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(fl, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> rbind(U u) {
        return FloatObjToShortE.rbind(this, u);
    }

    /**
     * Binds {@code (fl, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(FloatObjToShortE<U, E> f, float fl, U u) {
        return () -> f.call(fl, u);
    }

    /**
     * Binds {@code (fl, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl, u)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(float fl, U u) {
        return FloatObjToShortE.bind(this, fl, u);
    }
}
