package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (float, short) -> double}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface FloatShortToDblE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    double call(float fl, short sh) throws E;

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToDblE<E>
    bind(FloatShortToDblE<E> f, float fl) {
        return (sh) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param fl argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToDblE<E> bind(float fl) {
        return FloatShortToDblE.bind(this, fl);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (float fl) -> double} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToDblE<E>
    rbind(FloatShortToDblE<E> f, short sh) {
        return (fl) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> double}.
     *
     * @param sh argument 2
     * @return a new function {@code (float fl) -> double} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToDblE<E> rbind(short sh) {
        return FloatShortToDblE.rbind(this, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToDblE<E>
    bind(FloatShortToDblE<E> f, float fl, short sh) {
        return () -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToDblE<E> bind(float fl, short sh) {
        return FloatShortToDblE.bind(this, fl, sh);
    }
}
