package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (float, short) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface FloatShortToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @throws E if the operation cannot be completed
     */
    void call(float fl, short sh) throws E;

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(fl, sh)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    bind(FloatShortToNilE<E> f, float fl) {
        return (sh) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param fl argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(fl, sh)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> bind(float fl) {
        return FloatShortToNilE.bind(this, fl);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (float fl) -> void} that calls
     *      {@code f.call(fl, sh)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToNilE<E>
    rbind(FloatShortToNilE<E> f, short sh) {
        return (fl) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> void}.
     *
     * @param sh argument 2
     * @return a new function {@code (float fl) -> void} that calls
     *      {@code this.call(fl, sh)}.
     */
    default net.mintern.functions.unary.checked.FloatToNilE<E> rbind(short sh) {
        return FloatShortToNilE.rbind(this, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(fl, sh)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(FloatShortToNilE<E> f, float fl, short sh) {
        return () -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(fl, sh)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(float fl, short sh) {
        return FloatShortToNilE.bind(this, fl, sh);
    }
}
