package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (float, short) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface FloatShortToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(float fl, short sh) throws E;

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToShortE<E>
    bind(FloatShortToShortE<E> f, float fl) {
        return (sh) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param fl argument 1
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToShortE<E> bind(float fl) {
        return FloatShortToShortE.bind(this, fl);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    rbind(FloatShortToShortE<E> f, short sh) {
        return (fl) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param sh argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> rbind(short sh) {
        return FloatShortToShortE.rbind(this, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(FloatShortToShortE<E> f, float fl, short sh) {
        return () -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(float fl, short sh) {
        return FloatShortToShortE.bind(this, fl, sh);
    }
}
