package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (int, boolean) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntBoolToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i argument 1
     * @param bool argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(int i, boolean bool) throws E;

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(i, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    bind(IntBoolToShortE<E> f, int i) {
        return (bool) -> f.call(i, bool);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param i argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(i, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> bind(int i) {
        return IntBoolToShortE.bind(this, i);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(i, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    rbind(IntBoolToShortE<E> f, boolean bool) {
        return (i) -> f.call(i, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param bool argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(i, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> rbind(boolean bool) {
        return IntBoolToShortE.rbind(this, bool);
    }

    /**
     * Binds {@code (i, bool)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(IntBoolToShortE<E> f, int i, boolean bool) {
        return () -> f.call(i, bool);
    }

    /**
     * Binds {@code (i, bool)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i, bool)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(int i, boolean bool) {
        return IntBoolToShortE.bind(this, i, bool);
    }
}
