package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (int, int) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntIntToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i1 argument 1
     * @param i2 argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(int i1, int i2) throws E;

    /**
     * Binds {@code (i1)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i1 argument 1
     * @return a new function {@code (int i2) -> short} that calls
     *      {@code f.call(i1, i2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    bind(IntIntToShortE<E> f, int i1) {
        return (i2) -> f.call(i1, i2);
    }

    /**
     * Binds {@code (i1)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param i1 argument 1
     * @return a new function {@code (int i2) -> short} that calls
     *      {@code this.call(i1, i2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> bind(int i1) {
        return IntIntToShortE.bind(this, i1);
    }

    /**
     * Binds {@code (i2)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i2 argument 2
     * @return a new function {@code (int i1) -> short} that calls
     *      {@code f.call(i1, i2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    rbind(IntIntToShortE<E> f, int i2) {
        return (i1) -> f.call(i1, i2);
    }

    /**
     * Binds {@code (i2)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param i2 argument 2
     * @return a new function {@code (int i1) -> short} that calls
     *      {@code this.call(i1, i2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> rbind(int i2) {
        return IntIntToShortE.rbind(this, i2);
    }

    /**
     * Binds {@code (i1, i2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i1 argument 1
     * @param i2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i1, i2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(IntIntToShortE<E> f, int i1, int i2) {
        return () -> f.call(i1, i2);
    }

    /**
     * Binds {@code (i1, i2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i1 argument 1
     * @param i2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i1, i2)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(int i1, int i2) {
        return IntIntToShortE.bind(this, i1, i2);
    }
}
