package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (int, long) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntLongToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i argument 1
     * @param l argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(int i, long l) throws E;

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(i, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    bind(IntLongToShortE<E> f, int i) {
        return (l) -> f.call(i, l);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param i argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(i, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> bind(int i) {
        return IntLongToShortE.bind(this, i);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(i, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    rbind(IntLongToShortE<E> f, long l) {
        return (i) -> f.call(i, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(i, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> rbind(long l) {
        return IntLongToShortE.rbind(this, l);
    }

    /**
     * Binds {@code (i, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(IntLongToShortE<E> f, int i, long l) {
        return () -> f.call(i, l);
    }

    /**
     * Binds {@code (i, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i, l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(int i, long l) {
        return IntLongToShortE.bind(this, i, l);
    }
}
