package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (int, short) -> char}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntShortToCharE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    char call(int i, short sh) throws E;

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToCharE<E>
    bind(IntShortToCharE<E> f, int i) {
        return (sh) -> f.call(i, sh);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param i argument 1
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToCharE<E> bind(int i) {
        return IntShortToCharE.bind(this, i);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (int i) -> char} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToCharE<E>
    rbind(IntShortToCharE<E> f, short sh) {
        return (i) -> f.call(i, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> char}.
     *
     * @param sh argument 2
     * @return a new function {@code (int i) -> char} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToCharE<E> rbind(short sh) {
        return IntShortToCharE.rbind(this, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToCharE<E>
    bind(IntShortToCharE<E> f, int i, short sh) {
        return () -> f.call(i, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToCharE<E> bind(int i, short sh) {
        return IntShortToCharE.bind(this, i, sh);
    }
}
