package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (int, short) -> double}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntShortToDblE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    double call(int i, short sh) throws E;

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToDblE<E>
    bind(IntShortToDblE<E> f, int i) {
        return (sh) -> f.call(i, sh);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param i argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToDblE<E> bind(int i) {
        return IntShortToDblE.bind(this, i);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (int i) -> double} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToDblE<E>
    rbind(IntShortToDblE<E> f, short sh) {
        return (i) -> f.call(i, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> double}.
     *
     * @param sh argument 2
     * @return a new function {@code (int i) -> double} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToDblE<E> rbind(short sh) {
        return IntShortToDblE.rbind(this, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToDblE<E>
    bind(IntShortToDblE<E> f, int i, short sh) {
        return () -> f.call(i, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToDblE<E> bind(int i, short sh) {
        return IntShortToDblE.bind(this, i, sh);
    }
}
