package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (int, short) -> R}.
 *
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntShortToObjE<R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(int i, short sh) throws E;

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.ShortToObjE<R, E>
    bind(IntShortToObjE<R, E> f, int i) {
        return (sh) -> f.call(i, sh);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param i argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToObjE<R, E> bind(int i) {
        return IntShortToObjE.bind(this, i);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (int i) -> R} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.IntToObjE<R, E>
    rbind(IntShortToObjE<R, E> f, short sh) {
        return (i) -> f.call(i, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> R}.
     *
     * @param sh argument 2
     * @return a new function {@code (int i) -> R} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToObjE<R, E> rbind(short sh) {
        return IntShortToObjE.rbind(this, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(IntShortToObjE<R, E> f, int i, short sh) {
        return () -> f.call(i, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(int i, short sh) {
        return IntShortToObjE.bind(this, i, sh);
    }
}
