package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (long, byte) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongByteToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l argument 1
     * @param b argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(long l, byte b) throws E;

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(l, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    bind(LongByteToShortE<E> f, long l) {
        return (b) -> f.call(l, b);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param l argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(l, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> bind(long l) {
        return LongByteToShortE.bind(this, l);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(l, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    rbind(LongByteToShortE<E> f, byte b) {
        return (l) -> f.call(l, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param b argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(l, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> rbind(byte b) {
        return LongByteToShortE.rbind(this, b);
    }

    /**
     * Binds {@code (l, b)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(l, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(LongByteToShortE<E> f, long l, byte b) {
        return () -> f.call(l, b);
    }

    /**
     * Binds {@code (l, b)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param l argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(l, b)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(long l, byte b) {
        return LongByteToShortE.bind(this, l, b);
    }
}
