package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (long, char) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongCharToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l argument 1
     * @param ch argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(long l, char ch) throws E;

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(l, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    bind(LongCharToShortE<E> f, long l) {
        return (ch) -> f.call(l, ch);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param l argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(l, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> bind(long l) {
        return LongCharToShortE.bind(this, l);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(l, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    rbind(LongCharToShortE<E> f, char ch) {
        return (l) -> f.call(l, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(l, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> rbind(char ch) {
        return LongCharToShortE.rbind(this, ch);
    }

    /**
     * Binds {@code (l, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(l, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(LongCharToShortE<E> f, long l, char ch) {
        return () -> f.call(l, ch);
    }

    /**
     * Binds {@code (l, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param l argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(l, ch)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(long l, char ch) {
        return LongCharToShortE.bind(this, l, ch);
    }
}
