package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (long, double) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongDblToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l argument 1
     * @param d argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(long l, double d) throws E;

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(l, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    bind(LongDblToShortE<E> f, long l) {
        return (d) -> f.call(l, d);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param l argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(l, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> bind(long l) {
        return LongDblToShortE.bind(this, l);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(l, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    rbind(LongDblToShortE<E> f, double d) {
        return (l) -> f.call(l, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param d argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(l, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> rbind(double d) {
        return LongDblToShortE.rbind(this, d);
    }

    /**
     * Binds {@code (l, d)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(l, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(LongDblToShortE<E> f, long l, double d) {
        return () -> f.call(l, d);
    }

    /**
     * Binds {@code (l, d)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param l argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(l, d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(long l, double d) {
        return LongDblToShortE.bind(this, l, d);
    }
}
