package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (long, float) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongFloatToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l argument 1
     * @param fl argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(long l, float fl) throws E;

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(l, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    bind(LongFloatToShortE<E> f, long l) {
        return (fl) -> f.call(l, fl);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param l argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(l, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> bind(long l) {
        return LongFloatToShortE.bind(this, l);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(l, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    rbind(LongFloatToShortE<E> f, float fl) {
        return (l) -> f.call(l, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(l, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> rbind(float fl) {
        return LongFloatToShortE.rbind(this, fl);
    }

    /**
     * Binds {@code (l, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(l, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(LongFloatToShortE<E> f, long l, float fl) {
        return () -> f.call(l, fl);
    }

    /**
     * Binds {@code (l, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param l argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(l, fl)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(long l, float fl) {
        return LongFloatToShortE.bind(this, l, fl);
    }
}
