package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (long, int) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongIntToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l argument 1
     * @param i argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(long l, int i) throws E;

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(l, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    bind(LongIntToShortE<E> f, long l) {
        return (i) -> f.call(l, i);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param l argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(l, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> bind(long l) {
        return LongIntToShortE.bind(this, l);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(l, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    rbind(LongIntToShortE<E> f, int i) {
        return (l) -> f.call(l, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(l, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> rbind(int i) {
        return LongIntToShortE.rbind(this, i);
    }

    /**
     * Binds {@code (l, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(l, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(LongIntToShortE<E> f, long l, int i) {
        return () -> f.call(l, i);
    }

    /**
     * Binds {@code (l, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param l argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(l, i)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(long l, int i) {
        return LongIntToShortE.bind(this, l, i);
    }
}
