package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (long, long) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongLongToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l1 argument 1
     * @param l2 argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(long l1, long l2) throws E;

    /**
     * Binds {@code (l1)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l1 argument 1
     * @return a new function {@code (long l2) -> short} that calls
     *      {@code f.call(l1, l2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    bind(LongLongToShortE<E> f, long l1) {
        return (l2) -> f.call(l1, l2);
    }

    /**
     * Binds {@code (l1)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param l1 argument 1
     * @return a new function {@code (long l2) -> short} that calls
     *      {@code this.call(l1, l2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> bind(long l1) {
        return LongLongToShortE.bind(this, l1);
    }

    /**
     * Binds {@code (l2)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l2 argument 2
     * @return a new function {@code (long l1) -> short} that calls
     *      {@code f.call(l1, l2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    rbind(LongLongToShortE<E> f, long l2) {
        return (l1) -> f.call(l1, l2);
    }

    /**
     * Binds {@code (l2)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param l2 argument 2
     * @return a new function {@code (long l1) -> short} that calls
     *      {@code this.call(l1, l2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> rbind(long l2) {
        return LongLongToShortE.rbind(this, l2);
    }

    /**
     * Binds {@code (l1, l2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l1 argument 1
     * @param l2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(l1, l2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(LongLongToShortE<E> f, long l1, long l2) {
        return () -> f.call(l1, l2);
    }

    /**
     * Binds {@code (l1, l2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param l1 argument 1
     * @param l2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(l1, l2)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(long l1, long l2) {
        return LongLongToShortE.bind(this, l1, l2);
    }
}
