package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (long, U) -> short}.
 *
 * @param <U> the type of argument 2
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongObjToShortE<U, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l argument 1
     * @param u argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(long l, U u) throws E;

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(l, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<U, E>
    bind(LongObjToShortE<U, E> f, long l) {
        return (u) -> f.call(l, u);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param l argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(l, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<U, E> bind(long l) {
        return LongObjToShortE.bind(this, l);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(l, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    rbind(LongObjToShortE<U, E> f, U u) {
        return (l) -> f.call(l, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(l, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> rbind(U u) {
        return LongObjToShortE.rbind(this, u);
    }

    /**
     * Binds {@code (l, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(l, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(LongObjToShortE<U, E> f, long l, U u) {
        return () -> f.call(l, u);
    }

    /**
     * Binds {@code (l, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param l argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(l, u)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(long l, U u) {
        return LongObjToShortE.bind(this, l, u);
    }
}
