package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (long, short) -> boolean}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongShortToBoolE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    boolean call(long l, short sh) throws E;

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToBoolE<E>
    bind(LongShortToBoolE<E> f, long l) {
        return (sh) -> f.call(l, sh);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param l argument 1
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToBoolE<E> bind(long l) {
        return LongShortToBoolE.bind(this, l);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (long l) -> boolean} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToBoolE<E>
    rbind(LongShortToBoolE<E> f, short sh) {
        return (l) -> f.call(l, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> boolean}.
     *
     * @param sh argument 2
     * @return a new function {@code (long l) -> boolean} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToBoolE<E> rbind(short sh) {
        return LongShortToBoolE.rbind(this, sh);
    }

    /**
     * Binds {@code (l, sh)} to {@code f}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @param sh argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToBoolE<E>
    bind(LongShortToBoolE<E> f, long l, short sh) {
        return () -> f.call(l, sh);
    }

    /**
     * Binds {@code (l, sh)} to {@code this}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param l argument 1
     * @param sh argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToBoolE<E> bind(long l, short sh) {
        return LongShortToBoolE.bind(this, l, sh);
    }
}
