package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (long, short) -> byte}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongShortToByteE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    byte call(long l, short sh) throws E;

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToByteE<E>
    bind(LongShortToByteE<E> f, long l) {
        return (sh) -> f.call(l, sh);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param l argument 1
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToByteE<E> bind(long l) {
        return LongShortToByteE.bind(this, l);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (long l) -> byte} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToByteE<E>
    rbind(LongShortToByteE<E> f, short sh) {
        return (l) -> f.call(l, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> byte}.
     *
     * @param sh argument 2
     * @return a new function {@code (long l) -> byte} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToByteE<E> rbind(short sh) {
        return LongShortToByteE.rbind(this, sh);
    }

    /**
     * Binds {@code (l, sh)} to {@code f}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @param sh argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToByteE<E>
    bind(LongShortToByteE<E> f, long l, short sh) {
        return () -> f.call(l, sh);
    }

    /**
     * Binds {@code (l, sh)} to {@code this}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param l argument 1
     * @param sh argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToByteE<E> bind(long l, short sh) {
        return LongShortToByteE.bind(this, l, sh);
    }
}
