package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (long, short) -> double}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongShortToDblE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    double call(long l, short sh) throws E;

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToDblE<E>
    bind(LongShortToDblE<E> f, long l) {
        return (sh) -> f.call(l, sh);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param l argument 1
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToDblE<E> bind(long l) {
        return LongShortToDblE.bind(this, l);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (long l) -> double} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToDblE<E>
    rbind(LongShortToDblE<E> f, short sh) {
        return (l) -> f.call(l, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> double}.
     *
     * @param sh argument 2
     * @return a new function {@code (long l) -> double} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToDblE<E> rbind(short sh) {
        return LongShortToDblE.rbind(this, sh);
    }

    /**
     * Binds {@code (l, sh)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToDblE<E>
    bind(LongShortToDblE<E> f, long l, short sh) {
        return () -> f.call(l, sh);
    }

    /**
     * Binds {@code (l, sh)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param l argument 1
     * @param sh argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToDblE<E> bind(long l, short sh) {
        return LongShortToDblE.bind(this, l, sh);
    }
}
