package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (long, short) -> int}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongShortToIntE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    int call(long l, short sh) throws E;

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToIntE<E>
    bind(LongShortToIntE<E> f, long l) {
        return (sh) -> f.call(l, sh);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param l argument 1
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToIntE<E> bind(long l) {
        return LongShortToIntE.bind(this, l);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (long l) -> int} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToIntE<E>
    rbind(LongShortToIntE<E> f, short sh) {
        return (l) -> f.call(l, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> int}.
     *
     * @param sh argument 2
     * @return a new function {@code (long l) -> int} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToIntE<E> rbind(short sh) {
        return LongShortToIntE.rbind(this, sh);
    }

    /**
     * Binds {@code (l, sh)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @param sh argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToIntE<E>
    bind(LongShortToIntE<E> f, long l, short sh) {
        return () -> f.call(l, sh);
    }

    /**
     * Binds {@code (l, sh)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param l argument 1
     * @param sh argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToIntE<E> bind(long l, short sh) {
        return LongShortToIntE.bind(this, l, sh);
    }
}
