package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (T, boolean) -> short}.
 *
 * @param <T> the type of argument 1
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjBoolToShortE<T, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t argument 1
     * @param bool argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(T t, boolean bool) throws E;

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(t, bool)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    bind(ObjBoolToShortE<T, E> f, T t) {
        return (bool) -> f.call(t, bool);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(t, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> bind(T t) {
        return ObjBoolToShortE.bind(this, t);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, bool)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<T, E>
    rbind(ObjBoolToShortE<T, E> f, boolean bool) {
        return (t) -> f.call(t, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param bool argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<T, E> rbind(boolean bool) {
        return ObjBoolToShortE.rbind(this, bool);
    }

    /**
     * Binds {@code (t, bool)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, bool)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ObjBoolToShortE<T, E> f, T t, boolean bool) {
        return () -> f.call(t, bool);
    }

    /**
     * Binds {@code (t, bool)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, bool)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(T t, boolean bool) {
        return ObjBoolToShortE.bind(this, t, bool);
    }
}
