package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (T, byte) -> short}.
 *
 * @param <T> the type of argument 1
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjByteToShortE<T, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t argument 1
     * @param b argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(T t, byte b) throws E;

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(t, b)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    bind(ObjByteToShortE<T, E> f, T t) {
        return (b) -> f.call(t, b);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(t, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> bind(T t) {
        return ObjByteToShortE.bind(this, t);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, b)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<T, E>
    rbind(ObjByteToShortE<T, E> f, byte b) {
        return (t) -> f.call(t, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param b argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<T, E> rbind(byte b) {
        return ObjByteToShortE.rbind(this, b);
    }

    /**
     * Binds {@code (t, b)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, b)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ObjByteToShortE<T, E> f, T t, byte b) {
        return () -> f.call(t, b);
    }

    /**
     * Binds {@code (t, b)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, b)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(T t, byte b) {
        return ObjByteToShortE.bind(this, t, b);
    }
}
