package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (T, double) -> short}.
 *
 * @param <T> the type of argument 1
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjDblToShortE<T, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t argument 1
     * @param d argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(T t, double d) throws E;

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(t, d)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    bind(ObjDblToShortE<T, E> f, T t) {
        return (d) -> f.call(t, d);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(t, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> bind(T t) {
        return ObjDblToShortE.bind(this, t);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, d)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<T, E>
    rbind(ObjDblToShortE<T, E> f, double d) {
        return (t) -> f.call(t, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param d argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<T, E> rbind(double d) {
        return ObjDblToShortE.rbind(this, d);
    }

    /**
     * Binds {@code (t, d)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, d)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ObjDblToShortE<T, E> f, T t, double d) {
        return () -> f.call(t, d);
    }

    /**
     * Binds {@code (t, d)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(T t, double d) {
        return ObjDblToShortE.bind(this, t, d);
    }
}
