package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (T, float) -> short}.
 *
 * @param <T> the type of argument 1
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjFloatToShortE<T, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t argument 1
     * @param fl argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(T t, float fl) throws E;

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(t, fl)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    bind(ObjFloatToShortE<T, E> f, T t) {
        return (fl) -> f.call(t, fl);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(t, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> bind(T t) {
        return ObjFloatToShortE.bind(this, t);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, fl)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<T, E>
    rbind(ObjFloatToShortE<T, E> f, float fl) {
        return (t) -> f.call(t, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<T, E> rbind(float fl) {
        return ObjFloatToShortE.rbind(this, fl);
    }

    /**
     * Binds {@code (t, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, fl)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ObjFloatToShortE<T, E> f, T t, float fl) {
        return () -> f.call(t, fl);
    }

    /**
     * Binds {@code (t, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, fl)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(T t, float fl) {
        return ObjFloatToShortE.bind(this, t, fl);
    }
}
