package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (T, long) -> short}.
 *
 * @param <T> the type of argument 1
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjLongToShortE<T, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t argument 1
     * @param l argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(T t, long l) throws E;

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(t, l)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    bind(ObjLongToShortE<T, E> f, T t) {
        return (l) -> f.call(t, l);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(t, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> bind(T t) {
        return ObjLongToShortE.bind(this, t);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, l)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<T, E>
    rbind(ObjLongToShortE<T, E> f, long l) {
        return (t) -> f.call(t, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<T, E> rbind(long l) {
        return ObjLongToShortE.rbind(this, l);
    }

    /**
     * Binds {@code (t, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, l)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ObjLongToShortE<T, E> f, T t, long l) {
        return () -> f.call(t, l);
    }

    /**
     * Binds {@code (t, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(T t, long l) {
        return ObjLongToShortE.bind(this, t, l);
    }
}
