package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (T, U) -> short}.
 *
 * @param <T> the type of argument 1
 * @param <U> the type of argument 2
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjObjToShortE<T, U, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t argument 1
     * @param u argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(T t, U u) throws E;

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(t, u)} and returns the result.
     */
    static <T, U, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<U, E>
    bind(ObjObjToShortE<T, U, E> f, T t) {
        return (u) -> f.call(t, u);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(t, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<U, E> bind(T t) {
        return ObjObjToShortE.bind(this, t);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, u)} and returns the result.
     */
    static <T, U, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<T, E>
    rbind(ObjObjToShortE<T, U, E> f, U u) {
        return (t) -> f.call(t, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<T, E> rbind(U u) {
        return ObjObjToShortE.rbind(this, u);
    }

    /**
     * Binds {@code (t, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of argument 1
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, u)} and returns the result.
     */
    static <T, U, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ObjObjToShortE<T, U, E> f, T t, U u) {
        return () -> f.call(t, u);
    }

    /**
     * Binds {@code (t, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, u)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(T t, U u) {
        return ObjObjToShortE.bind(this, t, u);
    }
}
