package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, boolean) -> byte}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortBoolToByteE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param bool argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    byte call(short sh, boolean bool) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> byte} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToByteE<E>
    bind(ShortBoolToByteE<E> f, short sh) {
        return (bool) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> byte}.
     *
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> byte} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToByteE<E> bind(short sh) {
        return ShortBoolToByteE.bind(this, sh);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToByteE<E>
    rbind(ShortBoolToByteE<E> f, boolean bool) {
        return (sh) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param bool argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToByteE<E> rbind(boolean bool) {
        return ShortBoolToByteE.rbind(this, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code f}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToByteE<E>
    bind(ShortBoolToByteE<E> f, short sh, boolean bool) {
        return () -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code this}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToByteE<E> bind(short sh, boolean bool) {
        return ShortBoolToByteE.bind(this, sh, bool);
    }
}
