package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, boolean) -> double}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortBoolToDblE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param bool argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    double call(short sh, boolean bool) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> double} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToDblE<E>
    bind(ShortBoolToDblE<E> f, short sh) {
        return (bool) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> double}.
     *
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> double} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToDblE<E> bind(short sh) {
        return ShortBoolToDblE.bind(this, sh);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToDblE<E>
    rbind(ShortBoolToDblE<E> f, boolean bool) {
        return (sh) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param bool argument 2
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToDblE<E> rbind(boolean bool) {
        return ShortBoolToDblE.rbind(this, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToDblE<E>
    bind(ShortBoolToDblE<E> f, short sh, boolean bool) {
        return () -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToDblE<E> bind(short sh, boolean bool) {
        return ShortBoolToDblE.bind(this, sh, bool);
    }
}
