package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, boolean) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortBoolToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param bool argument 2
     * @throws E if the operation cannot be completed
     */
    void call(short sh, boolean bool) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> void} that calls
     *      {@code f.call(sh, bool)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToNilE<E>
    bind(ShortBoolToNilE<E> f, short sh) {
        return (bool) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> void}.
     *
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> void} that calls
     *      {@code this.call(sh, bool)}.
     */
    default net.mintern.functions.unary.checked.BoolToNilE<E> bind(short sh) {
        return ShortBoolToNilE.bind(this, sh);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(sh, bool)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    rbind(ShortBoolToNilE<E> f, boolean bool) {
        return (sh) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param bool argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(sh, bool)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> rbind(boolean bool) {
        return ShortBoolToNilE.rbind(this, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(sh, bool)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(ShortBoolToNilE<E> f, short sh, boolean bool) {
        return () -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(sh, bool)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(short sh, boolean bool) {
        return ShortBoolToNilE.bind(this, sh, bool);
    }
}
