package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, byte) -> boolean}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortByteToBoolE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param b argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    boolean call(short sh, byte b) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (byte b) -> boolean} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToBoolE<E>
    bind(ShortByteToBoolE<E> f, short sh) {
        return (b) -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> boolean}.
     *
     * @param sh argument 1
     * @return a new function {@code (byte b) -> boolean} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToBoolE<E> bind(short sh) {
        return ShortByteToBoolE.bind(this, sh);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToBoolE<E>
    rbind(ShortByteToBoolE<E> f, byte b) {
        return (sh) -> f.call(sh, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param b argument 2
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToBoolE<E> rbind(byte b) {
        return ShortByteToBoolE.rbind(this, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code f}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToBoolE<E>
    bind(ShortByteToBoolE<E> f, short sh, byte b) {
        return () -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code this}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToBoolE<E> bind(short sh, byte b) {
        return ShortByteToBoolE.bind(this, sh, b);
    }
}
