package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, byte) -> char}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortByteToCharE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param b argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    char call(short sh, byte b) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (byte b) -> char} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToCharE<E>
    bind(ShortByteToCharE<E> f, short sh) {
        return (b) -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> char}.
     *
     * @param sh argument 1
     * @return a new function {@code (byte b) -> char} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToCharE<E> bind(short sh) {
        return ShortByteToCharE.bind(this, sh);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToCharE<E>
    rbind(ShortByteToCharE<E> f, byte b) {
        return (sh) -> f.call(sh, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param b argument 2
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToCharE<E> rbind(byte b) {
        return ShortByteToCharE.rbind(this, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToCharE<E>
    bind(ShortByteToCharE<E> f, short sh, byte b) {
        return () -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToCharE<E> bind(short sh, byte b) {
        return ShortByteToCharE.bind(this, sh, b);
    }
}
