package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, byte) -> float}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortByteToFloatE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param b argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    float call(short sh, byte b) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (byte b) -> float} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToFloatE<E>
    bind(ShortByteToFloatE<E> f, short sh) {
        return (b) -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> float}.
     *
     * @param sh argument 1
     * @return a new function {@code (byte b) -> float} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToFloatE<E> bind(short sh) {
        return ShortByteToFloatE.bind(this, sh);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToFloatE<E>
    rbind(ShortByteToFloatE<E> f, byte b) {
        return (sh) -> f.call(sh, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param b argument 2
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToFloatE<E> rbind(byte b) {
        return ShortByteToFloatE.rbind(this, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code f}, returning a new function
     * of type {@code () -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToFloatE<E>
    bind(ShortByteToFloatE<E> f, short sh, byte b) {
        return () -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code this}, returning a new function
     * of type {@code () -> float}.
     *
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToFloatE<E> bind(short sh, byte b) {
        return ShortByteToFloatE.bind(this, sh, b);
    }
}
