package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, byte) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortByteToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param b argument 2
     * @throws E if the operation cannot be completed
     */
    void call(short sh, byte b) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (byte b) -> void} that calls
     *      {@code f.call(sh, b)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToNilE<E>
    bind(ShortByteToNilE<E> f, short sh) {
        return (b) -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> void}.
     *
     * @param sh argument 1
     * @return a new function {@code (byte b) -> void} that calls
     *      {@code this.call(sh, b)}.
     */
    default net.mintern.functions.unary.checked.ByteToNilE<E> bind(short sh) {
        return ShortByteToNilE.bind(this, sh);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(sh, b)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    rbind(ShortByteToNilE<E> f, byte b) {
        return (sh) -> f.call(sh, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param b argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(sh, b)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> rbind(byte b) {
        return ShortByteToNilE.rbind(this, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(sh, b)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(ShortByteToNilE<E> f, short sh, byte b) {
        return () -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(sh, b)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(short sh, byte b) {
        return ShortByteToNilE.bind(this, sh, b);
    }
}
