package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, char) -> float}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortCharToFloatE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param ch argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    float call(short sh, char ch) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (char ch) -> float} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToFloatE<E>
    bind(ShortCharToFloatE<E> f, short sh) {
        return (ch) -> f.call(sh, ch);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> float}.
     *
     * @param sh argument 1
     * @return a new function {@code (char ch) -> float} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToFloatE<E> bind(short sh) {
        return ShortCharToFloatE.bind(this, sh);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToFloatE<E>
    rbind(ShortCharToFloatE<E> f, char ch) {
        return (sh) -> f.call(sh, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param ch argument 2
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToFloatE<E> rbind(char ch) {
        return ShortCharToFloatE.rbind(this, ch);
    }

    /**
     * Binds {@code (sh, ch)} to {@code f}, returning a new function
     * of type {@code () -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param ch argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToFloatE<E>
    bind(ShortCharToFloatE<E> f, short sh, char ch) {
        return () -> f.call(sh, ch);
    }

    /**
     * Binds {@code (sh, ch)} to {@code this}, returning a new function
     * of type {@code () -> float}.
     *
     * @param sh argument 1
     * @param ch argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToFloatE<E> bind(short sh, char ch) {
        return ShortCharToFloatE.bind(this, sh, ch);
    }
}
