package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, char) -> long}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortCharToLongE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param ch argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    long call(short sh, char ch) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (char ch) -> long} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToLongE<E>
    bind(ShortCharToLongE<E> f, short sh) {
        return (ch) -> f.call(sh, ch);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> long}.
     *
     * @param sh argument 1
     * @return a new function {@code (char ch) -> long} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToLongE<E> bind(short sh) {
        return ShortCharToLongE.bind(this, sh);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToLongE<E>
    rbind(ShortCharToLongE<E> f, char ch) {
        return (sh) -> f.call(sh, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param ch argument 2
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToLongE<E> rbind(char ch) {
        return ShortCharToLongE.rbind(this, ch);
    }

    /**
     * Binds {@code (sh, ch)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param ch argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToLongE<E>
    bind(ShortCharToLongE<E> f, short sh, char ch) {
        return () -> f.call(sh, ch);
    }

    /**
     * Binds {@code (sh, ch)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param sh argument 1
     * @param ch argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToLongE<E> bind(short sh, char ch) {
        return ShortCharToLongE.bind(this, sh, ch);
    }
}
