package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, char) -> R}.
 *
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortCharToObjE<R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param ch argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(short sh, char ch) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (char ch) -> R} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.CharToObjE<R, E>
    bind(ShortCharToObjE<R, E> f, short sh) {
        return (ch) -> f.call(sh, ch);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> R}.
     *
     * @param sh argument 1
     * @return a new function {@code (char ch) -> R} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToObjE<R, E> bind(short sh) {
        return ShortCharToObjE.bind(this, sh);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.ShortToObjE<R, E>
    rbind(ShortCharToObjE<R, E> f, char ch) {
        return (sh) -> f.call(sh, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param ch argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToObjE<R, E> rbind(char ch) {
        return ShortCharToObjE.rbind(this, ch);
    }

    /**
     * Binds {@code (sh, ch)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param ch argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(ShortCharToObjE<R, E> f, short sh, char ch) {
        return () -> f.call(sh, ch);
    }

    /**
     * Binds {@code (sh, ch)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param sh argument 1
     * @param ch argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(short sh, char ch) {
        return ShortCharToObjE.bind(this, sh, ch);
    }
}
