package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, double) -> int}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortDblToIntE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param d argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    int call(short sh, double d) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (double d) -> int} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToIntE<E>
    bind(ShortDblToIntE<E> f, short sh) {
        return (d) -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> int}.
     *
     * @param sh argument 1
     * @return a new function {@code (double d) -> int} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToIntE<E> bind(short sh) {
        return ShortDblToIntE.bind(this, sh);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToIntE<E>
    rbind(ShortDblToIntE<E> f, double d) {
        return (sh) -> f.call(sh, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param d argument 2
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToIntE<E> rbind(double d) {
        return ShortDblToIntE.rbind(this, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToIntE<E>
    bind(ShortDblToIntE<E> f, short sh, double d) {
        return () -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToIntE<E> bind(short sh, double d) {
        return ShortDblToIntE.bind(this, sh, d);
    }
}
