package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, double) -> R}.
 *
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortDblToObjE<R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param d argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(short sh, double d) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (double d) -> R} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.DblToObjE<R, E>
    bind(ShortDblToObjE<R, E> f, short sh) {
        return (d) -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> R}.
     *
     * @param sh argument 1
     * @return a new function {@code (double d) -> R} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToObjE<R, E> bind(short sh) {
        return ShortDblToObjE.bind(this, sh);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.ShortToObjE<R, E>
    rbind(ShortDblToObjE<R, E> f, double d) {
        return (sh) -> f.call(sh, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param d argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToObjE<R, E> rbind(double d) {
        return ShortDblToObjE.rbind(this, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(ShortDblToObjE<R, E> f, short sh, double d) {
        return () -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(short sh, double d) {
        return ShortDblToObjE.bind(this, sh, d);
    }
}
