package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, float) -> byte}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortFloatToByteE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    byte call(short sh, float fl) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (float fl) -> byte} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToByteE<E>
    bind(ShortFloatToByteE<E> f, short sh) {
        return (fl) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> byte}.
     *
     * @param sh argument 1
     * @return a new function {@code (float fl) -> byte} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToByteE<E> bind(short sh) {
        return ShortFloatToByteE.bind(this, sh);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToByteE<E>
    rbind(ShortFloatToByteE<E> f, float fl) {
        return (sh) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param fl argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToByteE<E> rbind(float fl) {
        return ShortFloatToByteE.rbind(this, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code f}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToByteE<E>
    bind(ShortFloatToByteE<E> f, short sh, float fl) {
        return () -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code this}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToByteE<E> bind(short sh, float fl) {
        return ShortFloatToByteE.bind(this, sh, fl);
    }
}
