package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, float) -> long}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortFloatToLongE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    long call(short sh, float fl) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (float fl) -> long} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToLongE<E>
    bind(ShortFloatToLongE<E> f, short sh) {
        return (fl) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> long}.
     *
     * @param sh argument 1
     * @return a new function {@code (float fl) -> long} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToLongE<E> bind(short sh) {
        return ShortFloatToLongE.bind(this, sh);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToLongE<E>
    rbind(ShortFloatToLongE<E> f, float fl) {
        return (sh) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param fl argument 2
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToLongE<E> rbind(float fl) {
        return ShortFloatToLongE.rbind(this, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToLongE<E>
    bind(ShortFloatToLongE<E> f, short sh, float fl) {
        return () -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToLongE<E> bind(short sh, float fl) {
        return ShortFloatToLongE.bind(this, sh, fl);
    }
}
