package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, float) -> R}.
 *
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortFloatToObjE<R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(short sh, float fl) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (float fl) -> R} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.FloatToObjE<R, E>
    bind(ShortFloatToObjE<R, E> f, short sh) {
        return (fl) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> R}.
     *
     * @param sh argument 1
     * @return a new function {@code (float fl) -> R} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToObjE<R, E> bind(short sh) {
        return ShortFloatToObjE.bind(this, sh);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.ShortToObjE<R, E>
    rbind(ShortFloatToObjE<R, E> f, float fl) {
        return (sh) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param fl argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToObjE<R, E> rbind(float fl) {
        return ShortFloatToObjE.rbind(this, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(ShortFloatToObjE<R, E> f, short sh, float fl) {
        return () -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(short sh, float fl) {
        return ShortFloatToObjE.bind(this, sh, fl);
    }
}
