package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, float) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortFloatToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(short sh, float fl) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    bind(ShortFloatToShortE<E> f, short sh) {
        return (fl) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param sh argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> bind(short sh) {
        return ShortFloatToShortE.bind(this, sh);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToShortE<E>
    rbind(ShortFloatToShortE<E> f, float fl) {
        return (sh) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToShortE<E> rbind(float fl) {
        return ShortFloatToShortE.rbind(this, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ShortFloatToShortE<E> f, short sh, float fl) {
        return () -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(short sh, float fl) {
        return ShortFloatToShortE.bind(this, sh, fl);
    }
}
