package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, int) -> byte}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortIntToByteE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    byte call(short sh, int i) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (int i) -> byte} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToByteE<E>
    bind(ShortIntToByteE<E> f, short sh) {
        return (i) -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> byte}.
     *
     * @param sh argument 1
     * @return a new function {@code (int i) -> byte} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToByteE<E> bind(short sh) {
        return ShortIntToByteE.bind(this, sh);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToByteE<E>
    rbind(ShortIntToByteE<E> f, int i) {
        return (sh) -> f.call(sh, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param i argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToByteE<E> rbind(int i) {
        return ShortIntToByteE.rbind(this, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code f}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToByteE<E>
    bind(ShortIntToByteE<E> f, short sh, int i) {
        return () -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code this}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToByteE<E> bind(short sh, int i) {
        return ShortIntToByteE.bind(this, sh, i);
    }
}
