package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, int) -> long}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortIntToLongE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    long call(short sh, int i) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (int i) -> long} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToLongE<E>
    bind(ShortIntToLongE<E> f, short sh) {
        return (i) -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> long}.
     *
     * @param sh argument 1
     * @return a new function {@code (int i) -> long} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToLongE<E> bind(short sh) {
        return ShortIntToLongE.bind(this, sh);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToLongE<E>
    rbind(ShortIntToLongE<E> f, int i) {
        return (sh) -> f.call(sh, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param i argument 2
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToLongE<E> rbind(int i) {
        return ShortIntToLongE.rbind(this, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(sh, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToLongE<E>
    bind(ShortIntToLongE<E> f, short sh, int i) {
        return () -> f.call(sh, i);
    }

    /**
     * Binds {@code (sh, i)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param sh argument 1
     * @param i argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(sh, i)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToLongE<E> bind(short sh, int i) {
        return ShortIntToLongE.bind(this, sh, i);
    }
}
