package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, long) -> long}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortLongToLongE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    long call(short sh, long l) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (long l) -> long} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToLongE<E>
    bind(ShortLongToLongE<E> f, short sh) {
        return (l) -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> long}.
     *
     * @param sh argument 1
     * @return a new function {@code (long l) -> long} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToLongE<E> bind(short sh) {
        return ShortLongToLongE.bind(this, sh);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToLongE<E>
    rbind(ShortLongToLongE<E> f, long l) {
        return (sh) -> f.call(sh, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param l argument 2
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToLongE<E> rbind(long l) {
        return ShortLongToLongE.rbind(this, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToLongE<E>
    bind(ShortLongToLongE<E> f, short sh, long l) {
        return () -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToLongE<E> bind(short sh, long l) {
        return ShortLongToLongE.bind(this, sh, l);
    }
}
