package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, long) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortLongToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param l argument 2
     * @throws E if the operation cannot be completed
     */
    void call(short sh, long l) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (long l) -> void} that calls
     *      {@code f.call(sh, l)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToNilE<E>
    bind(ShortLongToNilE<E> f, short sh) {
        return (l) -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> void}.
     *
     * @param sh argument 1
     * @return a new function {@code (long l) -> void} that calls
     *      {@code this.call(sh, l)}.
     */
    default net.mintern.functions.unary.checked.LongToNilE<E> bind(short sh) {
        return ShortLongToNilE.bind(this, sh);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(sh, l)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    rbind(ShortLongToNilE<E> f, long l) {
        return (sh) -> f.call(sh, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param l argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(sh, l)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> rbind(long l) {
        return ShortLongToNilE.rbind(this, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(sh, l)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(ShortLongToNilE<E> f, short sh, long l) {
        return () -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(sh, l)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(short sh, long l) {
        return ShortLongToNilE.bind(this, sh, l);
    }
}
