package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, long) -> R}.
 *
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortLongToObjE<R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(short sh, long l) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (long l) -> R} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.LongToObjE<R, E>
    bind(ShortLongToObjE<R, E> f, short sh) {
        return (l) -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> R}.
     *
     * @param sh argument 1
     * @return a new function {@code (long l) -> R} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToObjE<R, E> bind(short sh) {
        return ShortLongToObjE.bind(this, sh);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.ShortToObjE<R, E>
    rbind(ShortLongToObjE<R, E> f, long l) {
        return (sh) -> f.call(sh, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param l argument 2
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToObjE<R, E> rbind(long l) {
        return ShortLongToObjE.rbind(this, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(ShortLongToObjE<R, E> f, short sh, long l) {
        return () -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(short sh, long l) {
        return ShortLongToObjE.bind(this, sh, l);
    }
}
