package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, long) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortLongToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(short sh, long l) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    bind(ShortLongToShortE<E> f, short sh) {
        return (l) -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param sh argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> bind(short sh) {
        return ShortLongToShortE.bind(this, sh);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToShortE<E>
    rbind(ShortLongToShortE<E> f, long l) {
        return (sh) -> f.call(sh, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToShortE<E> rbind(long l) {
        return ShortLongToShortE.rbind(this, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(sh, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ShortLongToShortE<E> f, short sh, long l) {
        return () -> f.call(sh, l);
    }

    /**
     * Binds {@code (sh, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param sh argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(sh, l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(short sh, long l) {
        return ShortLongToShortE.bind(this, sh, l);
    }
}
